;;;  Loop Project Version 2 
;;;  control batch file for typechecking test files  
;;; 
;;; files contains the list of pvs files to typecheck 
;;; since there might be no valid pvs context it is important that 
;;; the files come in the right order  
;;; (do not forget ccsl-prelude.pvs !) 
;;; 
;;; use -batch option of the loop compiler to generate this file 
;;; 
;;; to start pvs in batch mode, type 
;;;     pvs -batch -v <verbos-value> -l <this file> 
;;; where verbose-value is between 0 and 3 
;;;
             
(setq files '(
	  "defs"
	  "ccsl_prelude"
	  "BaseTypes_basic"
	  "SetSig_basic"
	  "MapFlatSig_basic"
	  "AnonymousSignature_1__basic"
	  "RelSig_basic"

	  "MapFlatSig_theory"
	  
	  "Project_basic"
	  "Employee_basic"
	  "AnonymousSignature_2__basic"
	  "Department_basic"
	  "Configuration_basic"

	  "RelSig_theory"

	  "FProject_basic"
	  "FEmployee_basic"
	  "FDepartment_basic"
	  "FlatCompany_basic"

	  "Project_model"
	  "Employee_model"
	  "Department_model"
	  "Configuration_model"

	  "FProject_model"
	  "FEmployee_model"
	  "FDepartment_model"

	  "more-assert"
	  "employee-compare"
	  "department-compare"
	  "configuration_compare"
	  "configuration_compare_from"

	  "FlatCompany_model"
	  
	  "all"
	))

;;; the body: typecheck each of the files 

(setq current-prefix-arg t) 
(mapcar (lambda (f) 
	(message (concat "\n--> Typechecking " f)) 
	(typecheck f) 
	;(prove-pvs-file f) 
	) 
files) 
