(*
 * The LOOP Project
 *
 * The LOOP Team, Dresden University and Nijmegen University
 *
 * Copyright (C) 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the
 * parent directories for more details.
 *
 * Created 14.5.99 by Hendrik
 *
 * Time-stamp: <Wednesday 26 June 02 19:57:22 tews@ithif51>
 *
 * the class for ccsl adt's and classes
 *
 * $Id: iface_class.ml,v 1.16 2002/07/03 12:01:14 tews Exp $
 *
 *)

open Util
open Global
open Top_variant_types
open Top_variant_types_util
open Top_classes
open Classtypes
open Interface_theory
open Methodinv_theory
open Bisim_theory
open Morphism_theory
open Full_liftings_theory
open Semantics_theory
open Class_theorems_theory
open Adt_theory
open Sig_theory
open Types_util
;;

class ['member_type, 'theory_body_type, 'super_class] ccsl_pre_iface_class
  name					(* the token *)
  local 				(* the local table *)
  prelude_flag				(* true for the prelude *)
  : ['member_type, 'theory_body_type, 'super_class] ccsl_pre_iface_type 
  = 
  object (self : 'self)

    inherit ['member_type, 'theory_body_type, 'super_class] 
      top_pre_iface_class name local
      as top_iface

  (*
    constraint 'member_type = 'super_class #ccsl_pre_member_type
  *)

    (*******************************************************************
     *
     * new features
     *)

    method belongs_to_prelude = (prelude_flag : bool)


      (* convenience method has_constructors, 
       * tells if self#get_constructors <> [] 
       * recorded in add_member
       *)

    val mutable has_constructors = false

    method has_constructors = has_constructors


    (*******************************************************************
     * final or loose model coalgebra
     *)

    method get_model_coalgebra =
      if self#has_feature FinalSemanticsFeature
      then Term(Top_names.name_of_final_coalgebra self, Always,[])
      else Term(Top_names.name_of_loose_coalgebra self, Always,[])

    method get_model_algebra =
      if self#has_feature FinalSemanticsFeature
      then Term(Names.name_of_algebra_final self, Always,[])
      else Term(Names.name_of_algebra_loose self, Always,[])

    method get_model_type_argument args =
      let typename = 
	if self#has_feature FinalSemanticsFeature
	then Top_names.name_of_final_type self
	else Top_names.name_of_loose_type self
      in
	TypeArgument(TypeConstant(typename,Always,args))

    (*******************************************************************
     *
     * Instanciations
     *)

	(* instanciated classes have less features *)
    val mutable instanciated = false 

    method become_instanciated = instanciated <- true

    method is_instanciated = instanciated

    val mutable arguments = []

    method set_arguments args =
      arguments <- args

    method get_arguments =
      assert(instanciated);
      arguments

    (*******************************************************************
     *
     * variances
     *)

    val mutable self_var = Unset

    method get_self_variance = self_var

    method set_self_variance var = self_var <- var


    val mutable functor_type = UnknownFunctor

    method get_functor_type = functor_type

    method set_functor_type ft = functor_type <- ft

    (*******************************************************************
     *
     * inheritance
     *)

	(* During inheritance ancestor classes get 
	 * first instanciated, then in the instanciated copy
	 * the heir is set to the non-instanciated class that inherits
	 *)
    val mutable inherited_in = (None : 'super_class option)

    method inherit_to heir = 
      assert(instanciated && inheritance_ready);
      inherited_in <- Some heir;
      List.iter (fun acl -> acl#inherit_to heir) 
	(self#get_resolved_ancestors)

    method get_heir = 
      assert(inheritance_ready);
      inherited_in

    (*******************************************************************
     *
     * importings
     *)
  
    val mutable iface_importings = []
    val mutable assertion_importings = []
    val mutable theorem_importings = []

    method add_iface_import i = 
      assert(not instanciated);
      iface_importings <- iface_importings @ [i]

    method get_iface_imports = 
      assert(not instanciated);
      iface_importings

    method add_assertion_import i = 
      assert(not instanciated);
      assertion_importings <- assertion_importings @ [i]

    method get_assertion_imports = 
      assert(not instanciated);
      assertion_importings

    method add_theorem_import i = 
      assert(not instanciated);
      theorem_importings <- theorem_importings @ [i]

    method get_theorem_imports = 
      assert(not instanciated);
      theorem_importings

    (*******************************************************************
     *
     * parameters and arguments
     *)

    val mutable parameters = 
      ( [] : ('super_class, 'member_type) top_pre_parameter_type list)

    method add_parameter p = 
      assert(not instanciated);
      parameters <- parameters @ [p]

    method get_parameters = 
      assert(not instanciated);
      parameters

(*     method check_parameters args = 
 * 	 assert(not instanciated);
 * 	 check_parameters parameters args
 *)
    
    (*******************************************************************
     *
     * components
     *)

    val mutable components = 
      ([] : ('super_class, 'member_type) top_pre_component_type list)

      (* 
       * all components with all instanciations must be added !!
       * it is the responsibility of the caller, to traverse the 
       * argument list and add components in there first
       * see iter_component_arg and iter_components
       *)
    method add_component (v,c,inpargs) =
      let rec do_it args = function
	| ((v',c',args') as comp') :: l ->
	    if (c'#get_name = c#get_name) &&
	      (List.for_all2 eq_ccsl_args args args')
	    then
	      ((Logic_util.variance_join v v'), c', args') :: l
	    else comp' :: (do_it args l)
	| [] -> [(v,c,args)]
      in let this_parameters = self#get_parameters in
			(* returns true, if id is a local typeparameter *)
      let other_params_p id = 
	  List.for_all (function TypeParameter oid ->
			  oid.id_token.token_name <> id.id_token.token_name)
	    this_parameters
      in
	if c#instanciate_importings && self#instanciate_importings
	then
      	  components <- do_it inpargs components
	else
      	  components <- do_it [] components

    method get_components = components

    (*******************************************************************
     *
     * ancestors
     *)

     (* override, to treat components *)
    method add_ancestor a =
      assert(not instanciated);
(* not needed (I hope)
 *       (match a with 
 * 	 | Unresolved_renaming(anc,args,renamings) ->
 * 				   (* get components for the instanciation *)
 * 		iter_component_arglist true
 * 		  (fun c -> self#add_component c)
 * 		  args
 *
 *	 | _ -> assert (false)
 *      );
 *)
      top_iface#add_ancestor a


	(* override *)
    method get_resolved_ancestors =
      assert(inheritance_ready);
      top_iface#get_resolved_ancestors


    (*******************************************************************
     *
     * members
     * 
     * override add_member to treat components
     *)

    method add_member m =
      Symbol.create_local local m#get_name (MemberSymb m);
      if not has_constructors && m#is_constructor 
      then has_constructors <- true;
      top_iface#add_member m
	

    (*******************************************************************
     *
     * local symboltables
     * 
     *)

	(* filled in inheritance pass, retained in instanciations 
	 * contains also the own local table
	 *)
    val mutable inherited_locals =
      ([local] : ('super_class, 'member_type) top_pre_scope_type list)

    method get_inherited_locals = inherited_locals

    method inherit_locals locs = 
      inherited_locals <- inherited_locals @ locs

      (* search in the local symboltable of this class *)
    method find_local name = Table.find_local local CCSL_ID name 

    (* The next two functions were in top_iface before, but 
     * the symboltable is so different, that they make no sense there
     *
     * find a member, among all (also inherited members
     * a call is only valid, if the inheritance pass is done
     * maybe raise Member_not_found
     *)
    method find_member name =
      let _ = assert (inheritance_ready) in
      let rec doit = function
	| [] -> raise Member_not_found
	| loc :: rest -> 
	    try
	      (match Table.find_local loc CCSL_ID name with
		| MemberSymb m -> m
			(* a method is always stored as Member *)
		| _ -> assert(false)
	      )
	    with Table.Not_defined -> doit rest
      in
	doit inherited_locals

    (* find a member in this class
     * maybe raise Member_not_found
     *)
    method find_local_member name =
      try
	match self#find_local name with
	  | MemberSymb m -> m
			(* a method is always stored as Member *)
	  | _ -> raise Member_not_found
      with Table.Not_defined -> raise Member_not_found

    (*******************************************************************
     *
     * Signature stuff
     *)

    val mutable ground_types = 
        ( [] : 
	    ('super_class, 'member_type) top_pre_identifier_record_type list)

    val mutable sequence_counter = 0

    val mutable has_own_output = false
				   
    method has_own_output = 
      assert(self#get_kind = Spec_sig);
      has_own_output

	(* If true, importings with this class and importings for 
	 * this class are fully instanciated.
	 * If false generic importings are used.
	 * The flag is reset to false in ground signatures that have 
	 * some item with local type parameters. In this case the 
	 * instaciation for an importing might contain a local type 
	 * variable, or it might have too much arguments. In both 
	 * cases the instanciation must be supressed.
	 *)
    val mutable instanciated_importings = true

    method instanciate_importings = instanciated_importings

    method add_ground_type gt  = 
      assert(self#get_kind = Spec_sig);
      Symbol.create_local local gt.id_token.token_name
	(CCSL_GroundTypeSymb gt);
      (match gt.id_origin with
	 | CCSL_GroundTypeDef _ ->
	     begin
	       gt.id_sequence <- sequence_counter;
	       sequence_counter <- sequence_counter +1;
	       has_own_output <- true
	     end
	 | CCSL_GroundTypeDecl _ -> ()
	 | _ -> assert(false)
      );
      if gt.id_parameters <> [] then
	instanciated_importings <- false;
      ground_types <- ground_types @ [gt]

    method get_all_ground_types = 
      assert(self#get_kind = Spec_sig);
      ground_types

    (*******************************************************************
     *
     * definitional extensions
     *)

    val mutable definitions = [] 

    method add_definition def =
      self#add_member def.defined_method;
      definitions <- definitions @ [def];
      if self#get_kind = Spec_sig then begin
	has_own_output <- true;
	def.def_sequence <- sequence_counter;
	sequence_counter <- sequence_counter +1;
      end;
      if def.defined_method#get_local_parameters <> [] then
	instanciated_importings <- false
      
    method get_definitions = definitions

    (*******************************************************************
     *
     * assertions and creation conditions
     *)

    val mutable assertions = 
      ( [] : ('super_class, 'member_type) top_pre_assertion_record list)
    val mutable creations = 
      ( [] : ('super_class, 'member_type) top_pre_assertion_record list)
    val mutable theorems = 
      ( [] : ('super_class, 'member_type) top_pre_assertion_record list)

    method add_assertion a = 
      assert(not instanciated);
      assertions <- assertions @ [a]

    method get_assertions = assertions

    method set_assertions ass =
      assertions <- ass

    method add_creation c = 
      assert(not instanciated);
      creations <- creations @ [c]

    method get_creations = creations

    method set_creations cre =
      creations <- cre

    method add_theorem c = 
      assert(not instanciated);
      theorems <- theorems @ [c]

    method get_theorems = theorems

    (*******************************************************************
     *
     * Liftings, doku see iface_type 
     *)

    val mutable lifting_requests = 
      ([] : (string * ('super_class, 'member_type) top_pre_types) list)

    method add_lifting name typ =
      lifting_requests <- lifting_requests @ [name,typ]

    method get_lifting_requests = lifting_requests

    (*******************************************************************
     *
     * Relation Liftings, doku see iface_type 
     *)
	
    val mutable rel_lifting_requests = 
      ([] : (('super_class, 'member_type) top_pre_types * string) list)
      
    val mutable rel_lifting_num = 0
      
    method add_rel_lifting name typ =
      if List.exists
	(fun (t,n) -> (n = name) & (eq_ccsl_types typ t))
	rel_lifting_requests
      then
	()
      else
	let nname = 
	  if name = "" then
	    begin
	      rel_lifting_num <- rel_lifting_num +1;
	      self#get_name ^ "ObsEq_" ^ (string_of_int rel_lifting_num)
	    end
	  else
	    name
	in
	  begin
(* 	       iter_components true (fun c -> self#add_component c) typ;
 *)
	    rel_lifting_requests <- rel_lifting_requests @ [typ,nname]
	  end

	
    method get_rel_lifting_requests = rel_lifting_requests

    method find_rel_lifting_for_type typ = 
      Util.assoc eq_ccsl_types typ rel_lifting_requests

    (*******************************************************************
     *
     * Theory generation
     *)

    method generate_all_theories =
      let _ = assert(not instanciated) in
					(* do some type conversion first *)
      let self'  : ('member_type, 'theory_body_type, 'super_class) 
 	ccsl_pre_iface_type  = 
	(self :> ('member_type, 'theory_body_type, 'super_class) 
	   ccsl_pre_iface_type) 
	in
      let class_typeconvert 
	(th : ccsl_class_theory_type ) =
	(th :> (('member_type, 'theory_body_type, 'super_class)
		  ccsl_pre_iface_type,
		  ('super_class, 'member_type) ccsl_pre_member_type)
	       ccsl_pre_theory_body_type) in
      let adt_typeconvert 
	(th : ccsl_adt_theory_type ) =
	(th :> (('member_type, 'theory_body_type, 'super_class)
	          ccsl_pre_iface_type,
		  ('super_class, 'member_type) ccsl_pre_member_type)
	       ccsl_pre_theory_body_type) in
      let sig_typeconvert 
	(th : ccsl_sig_theory_type ) =
	(th :> (('member_type, 'theory_body_type, 'super_class)
	          ccsl_pre_iface_type,
		  ('super_class, 'member_type) ccsl_pre_member_type)
	       ccsl_pre_theory_body_type) in

      match self#get_kind with 
					(* generate classes *)
  	| Spec_class ->			
	    [
		(* DOC     \name{class}\texttt{Interface} & *)
		(* DOC2        signature declaration  *)
	      (class_typeconvert (new ccsl_interface_theory self' ));

		(* DOC     \name{class}\texttt{Method\_Id} & *)
		(* DOC2        \raggedright *)
		(* DOC2        tags for method wise modal operators  *)
	      (class_typeconvert (new ccsl_method_idtype_adt self'));

		(* DOC    \name{class}\texttt{MethodPredicateLifting} & *)
		(* DOC2       \raggedright (method wise) predicate lifting, *)
		(* DOC2       method-wise invariants *)
	     (class_typeconvert (new ccsl_method_lift_theory self'));

(* 		(class_typeconvert
 * 		   (new ccsl_lift_theory self'));
 * 		(class_typeconvert
 * 		   (new ccsl_private_invariance_rewrite_theory self'));
 * 		(class_typeconvert
 * 		   (new ccsl_public_invariance_rewrite_theory self'));
 *)


		(* DOC     \name{class}\texttt{MethodInvariantRewrite} & *)
		(* DOC2       utility lemmas for invariants *)
	     (class_typeconvert
		(new ccsl_method_invariance_rewrite_theory self'));

		(* DOC     \name{class}\texttt{MethodInvariantInherit} & *)
		(* DOC2       \raggedright  *)
		(* DOC2       link methodwise invariants with super classes *)
	     (class_typeconvert
		(new ccsl_method_invariance_inherit_theory self'));

(* Jan: what is this GI stuff good for ??
 *	     (class_typeconvert
 *		(new ccsl_greatest_invariance_theory self'));
 * !!!  I also changed the importing in the box theory !!!
 *)

		(* DOC     \name{class}\texttt{Box} & *)
		(* DOC2       (method wise) modal operators *)
	     (class_typeconvert
		(new ccsl_box_theory self'));

		(* DOC     \name{class}\texttt{BoxInherit} & *)
		(* DOC2       \raggedright *)
		(* DOC2       link modal operators with super classes *)
	     (class_typeconvert
		(new ccsl_box_inherit_theory self'))
	    ] @ ( 

	      if (!ccsl_generate_paths) then
		[ (adt_typeconvert
		     (new ccsl_step_adt self'));
		  (class_typeconvert
		     (new ccsl_path_theory self'))]
	      else
		[]
	    ) @ (
	      if self#has_feature HasBisimulationFeature then
		[

		(* DOC     \name{class}\texttt{Bisimilarity}% *)
		(* DOC2        \index{bisimilarity}  & *)
		(* DOC2        relation lifting and bisimulations *)
		  (class_typeconvert 
	             (new ccsl_bibisim_theory self'))
		] @ (
		  if self#has_feature HasGreatestBisimFeature
		  then
		    [

		(* DOC     \name{class}\texttt{BisimilarityRewrite} & *)
		(* DOC2       utility lemmas for bisimulations *)
		      (class_typeconvert 
			 (new ccsl_private_bibisim_rewrite_theory self'));

		(* DOC     \name{class}\texttt{PublicBisimilarityRewrite} & *)
		(* DOC2       \raggedright *)
		(* DOC2       utility lemmas for bisimulations  *)
		(* DOC2       with respect to the public *)
		      (class_typeconvert 
			 (new ccsl_public_bibisim_rewrite_theory self'))
		    ]
		  else 
		    []
		) @ [

		(* DOC     \name{class}\texttt{BisimilarityEquivalence} & *)
		(* DOC2       \raggedright *)
		(* DOC2       bisimulation on one model, bisimilarity *)
		  (class_typeconvert 
	             (new ccsl_bisim_eq_theory self'))
		] @ (
		  if self#has_feature HasGreatestBisimFeature
		  then
		    [

		(* DOC     \name{class}\texttt{BisimilarityEqRewrite} & *)
		(* DOC2       utility lemmas for bisimilarity *)
		      (class_typeconvert 
			 (new ccsl_private_bisim_eq_rewrite_theory self'));

	      (* DOC     \name{class}\texttt{PublicBisimilarityEqRewrite} & *)
		(* DOC2       \raggedright *)
		(* DOC2       utility lemmas for bisimilarity with  *)
		(* DOC2       respect to the public subsignature *)
		      (class_typeconvert 
			 (new ccsl_public_bisim_eq_rewrite_theory self'))
		    ]
		  else
		    []
		)
	      else
		[]
	    ) @ (
	      if self#get_rel_lifting_requests = [] then 
		[]
	      else 

		(* DOC     \name{class}\texttt{ReqObsEq} & *)
		(* DOC2       additional liftings *)
		[ (class_typeconvert
		     (new ccsl_req_bisim_theory self'))
		]
	    ) @ (

	      if self#has_feature HasMorphismFeature
	      then 
		[

		(* DOC     \name{class}\texttt{Morphism} & *)
		(* DOC2       \raggedright *)
		(* DOC2        definition of \name{class}--coalgebra  *)
		(* DOC2 	morphisms *)
		  (class_typeconvert 
		     (new ccsl_morphism_theory self'));

		(* DOC     \name{class}\texttt{MorphismRewrite} & *)
		(* DOC2        utility lemmas for morphisms *)
		  (class_typeconvert 
		     (new ccsl_morphism_rewrite_theory self'));
		]
	      else []

	    ) @ (
	      [

		(* DOC     \name{class}\texttt{Semantics} & *)
		(* DOC2        semantics of the specification *)
		(class_typeconvert 
	           (new ccsl_semantics_theory self'));

		(* DOC     \name{class}\texttt{Basic} & *)
		(* DOC2       \raggedright *)
		(* DOC2        utility lemmas for assertions  *)
		(* DOC2 	and creation conditions *)
		(class_typeconvert 
	           (new ccsl_basic_theory self'));

		(* DOC     \name{class}\texttt{FullInvariant} & *)
		(* DOC2       \raggedright *)
		(* DOC2        full predicate lifting and every combinator *)
		(class_typeconvert
                   (new ccsl_full_invariant_theory self'));
	      ] 
	    ) @ (

	      if self#has_feature HasFullRelLiftingFeature then
		[

		(* DOC     \name{class}\texttt{FullBisimulation} & *)
		(* DOC2       \raggedright *)
		(* DOC2        full relation lifting  *)
		(* DOC2        and relevery combinator *)
		  (class_typeconvert
                     (new ccsl_full_bibisim_theory self'));
		]
	      else
		[]
	    ) @ (

	      if self#has_feature HasMorphismFeature
	      then 
		[

		(* DOC     \name{class}\texttt{Finality} & *)
		(* DOC2       \raggedright *)
		(* DOC2        properties of the final  *)
		(* DOC2        \name{class}--coalgebra, coreduce *)
		  (class_typeconvert 
		     (new ccsl_finality_theory self'));
		]
	      else []

	    ) @ (

	      if (self#has_feature HasMorphismFeature) &&
		(self#has_feature HasGreatestBisimFeature)
	      then 
		[
		(* DOC     \name{class}\texttt{FinalityBisim} & *)
		(* DOC2       Bisimilarity on the final model *)
		  (class_typeconvert 
		     (new ccsl_finality_bisim_theory self'));
		]
	      else []

	    ) @ (

	      if self#has_feature FinalSemanticsFeature then
		[

		(* DOC     \name{class}\texttt{Final} & *)
		(* DOC2        axiomatic final model *)
		  (class_typeconvert (new ccsl_final_theory self'));

		(* DOC     \name{class}\texttt{FinalProp} & *)
		(* DOC2        axiom for final model *)
		  (class_typeconvert (new ccsl_final_props_theory self'));
		] @ (
		  if self#has_feature HasMapFeature then
		    [

		(* DOC     \name{class}\texttt{MapStruct} & *)
		(* DOC2       \raggedright *)
		(* DOC2        coalgebra structure for map combinator *)
		      (class_typeconvert (new ccsl_map_struct_theory self'));

		(* DOC     \name{class}\texttt{Map} & *)
		(* DOC2        map combinator *)
		      (class_typeconvert (new ccsl_map_theory self'));
		    ]
		  else
		    []
		)
	      else
		[

		(* DOC     \name{class}\texttt{Loose} & *)
		(* DOC2        axiomatic loose model *)
		  (class_typeconvert (new ccsl_loose_theory self'));
		]

	    ) @ (

		(* DOC     \name{class} & *)
		(* DOC2        top level import theory for \name{class} *)
	      [
		(class_typeconvert (new ccsl_coadt_theory self'));
	      ]

	    ) @ (

	      if self#get_theorems <> [] then
		[

		(* DOC     \name{class}\texttt{Theorem} & *)
		(* DOC2        tranlated theorem section *)
		  class_typeconvert (new ccsl_class_theorem_theory self')
		]
	      else
		[]
	    )
					(* generate adt's *)
  	| Spec_adt -> 
	    (match !output_mode with
	       | Pvs_mode -> 
		   if self#has_feature BuildinFeature
		   then []
		   else
		     (* DOC   \name{adt} & data type declaration *)
		     [adt_typeconvert (new ccsl_pvs_adt_theory self')]
	       | Isa_mode ->
		   (if self#has_feature BuildinFeature
		    then []
		    else 
		      [adt_typeconvert (new ccsl_isa_adt_theory self')]
		   )
		   @
		   [
		     (* DOC   \name{adt}\texttt{Util} & *)
		     (* DOC2        reduce, accessors, recognisers *)
		    adt_typeconvert (new ccsl_isa_adtutil_theory self')
		   ]
	    ) @ (
	      if self#has_feature NeedsMapFeature 
	      then
		[
		  (* DOC   \name{adt}\texttt{Map} & map combinator *)
		  adt_typeconvert (new ccsl_adt_map_theory self');

		  (* DOC   \name{adt}\texttt{Every} & *)
		  (* DOC2         (full) predicate lifting *)
		  adt_typeconvert (new ccsl_adt_every_theory self')
		]
	      else
		[]
	    ) @ (
	      if self#has_feature HasRelLiftFeature
	      then
		(* DOC   \name{adt}\texttt{RelLift} & *)
		(* DOC2             (full) relation lifting *)
		[adt_typeconvert (new ccsl_adt_rellift_theory self')
		]
	      else
		[]
	    )

	| Spec_sig ->
	    (if self#has_own_output
	     then
	       List.map sig_typeconvert (ccsl_sig_def_theories self')
	     else
	       []
	    )
	    
  	| Spec_Spec 
	  -> assert(false)
	  
    (*******************************************************************
     *
     * Dumping
     *)

    method dump_iface =
      (if instanciated then "INSTANCIATED" else "") ^
      top_iface#dump_iface ^
      "Parameters: " ^ (dump_list dump_parameter "| " parameters) ^ "\n"
      

    (*******************************************************************
     *
     * override section
     *)



  end (* of ccsl_pre_iface_class *)



(*** Local Variables: ***)
(*** version-control: t ***)
(*** kept-new-versions: 5 ***)
(*** delete-old-versions: t ***)
(*** time-stamp-line-limit: 30 ***)
(*** End: ***)

