(* 
 * Formalized Cut Elimination in Coalgebraic Logics
 * 
 * Copyright (C) 2013 - 2013 Hendrik Tews
 * 
 * This file is part of my formalization of "Cut Elimination in 
 * Coalgebraic Logics" by Dirk Pattinson and Lutz Schroeder.
 * 
 * The formalization is free software: you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * The formalization is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the parent
 * directories for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with the formalization in the file COPYING. 
 * If not, see <http://www.gnu.org/licenses/>.
 * 
 * $Id: k_absorb.v,v 1.10 2013/04/10 11:17:15 tews Exp $
 *)

(** ** K example, Absorption properties and syntactic cut elimination, 5.2, 5.4

      This module proves absorbtion of congruence, contruction and cut
      for K and then derives the syntactic cut-elimination results.

      Note again, that no assumptions remaind from the generic
      theorems. 
 *)

(***************************************************************************)
(***************************************************************************)

Require Export k_syntax syntactic_cut.

Section K_absorb.


  (***************************************************************************)
  (** *** Absorbtion of congruence *)
  (***************************************************************************)

  Lemma k_absorbs_congruence : absorbs_congruence k_rules.
  Proof.
    unfold absorbs_congruence in *.
    intros op pv qv H H0.
    destruct op.
    simpl in *.
    assert (H1 := counted_list_eta_1 pv).
    destruct H1 as [f1].
    subst pv.
    assert (H1 := counted_list_eta_1 qv).
    destruct H1 as [f2].
    subst qv.
    simpl in *.
    apply every_nth_head in H.
    apply every_nth_head in H0.
    destruct f1 as [pv| | |]; try contradiction.
    destruct f2 as [qv| | |]; try contradiction.
    clear H H0.
    exists (k_rule 1), (rename_of_fun (k_rename_fun [qv; pv])).
    split.
      apply k_rules_rule.
    split.
      apply rank_renaming.
      apply renaming_rename_of_fun.
    split.
      exists [].
      simpl conclusion.
      rewrite subst_k_rename_k_conclusion.
      simpl.
      apply list_reorder_swap_head.
    apply every_nth_cons.
      simpl.
      unfold neg_v in *.
      repeat rewrite subst_form_char.
      unfold rename_of_fun in *.
      rewrite k_rename_fun_less with (n_less := lt_0_Sn 1).
      rewrite k_rename_fun_less with (n_less := lt_n_S _ _ (lt_0_Sn 0)).
      simpl.
      apply provable_with_assumption.
      unfold congruence_assumptions, congruence_assumption_list, 
                                     reordered_sequent_list_set in *.
      simpl.
      eexists.
      split.
        apply list_reorder_swap_head.
      auto.
    apply every_nth_empty.
  Qed.


  (***************************************************************************)
  (** *** Absorbtion of contraction *)
  (***************************************************************************)

  Lemma prop_var_sequent_support : forall(s : sequent KV KL),
    prop_sequent s ->
    every_nth neg_form s ->
      list_support kv_eq (prop_var_sequent s) =
        prop_var_sequent (sequent_support kop_eq kv_eq s).
  Proof.
    induction s.
      intros H H0.
      trivial.
    rename a into f.
    intros H H0.
    assert (H1 := H).
    assert (H2 := H0).
    apply prop_sequent_tail in H.
    apply every_nth_tail in H0.
    apply prop_sequent_head in H1.
    apply every_nth_head in H2.
    specialize (IHs H H0).
    rewrite prop_var_sequent_cons.
    destruct f; try contradiction.
    simpl in *.
    destruct f as [v| | |]; try contradiction.
    simpl.
    clear H1 H2.
    destruct (member kv_eq v (list_support kv_eq (prop_var_sequent s))) eqn:H1.
      assert (member (lambda_formula_eq kop_eq kv_eq) 
                (lf_neg (lf_prop v)) (sequent_support kop_eq kv_eq s) = true).
        apply member_In in H1.
        apply member_In.
        apply sequent_support_correct_content.
        apply list_support_incl in H1.
        apply In_prop_var_sequent in H1.
        destruct H1 as [f].
        destruct H1.
        apply every_nth_In with (a := f) in H; trivial.
        apply every_nth_In with (a := f) in H0; trivial.
        destruct f; try contradiction.
        destruct f; try contradiction.
        simpl in *.
        destruct H1.
          subst k.
          trivial.
        contradiction.
      rewrite H2.
      trivial.
    assert (member (lambda_formula_eq kop_eq kv_eq) 
              (lf_neg (lf_prop v)) (sequent_support kop_eq kv_eq s) = false).
      apply member_In_false in H1.
      apply member_In_false.
      intros H2.
      apply H1; clear H1.
      apply sequent_support_incl in H2.
      apply list_support_correct_content.
      eapply incl_prop_var_formula_sequent.
        eexact H2.
      simpl.
      auto.
    rewrite H2.
    rewrite prop_var_sequent_cons.
    simpl.
    f_equal.
    trivial.
  Qed.


  Lemma k_absorbs_contraction : absorbs_contraction kop_eq kv_eq k_rules.
  Proof.
    unfold absorbs_contraction in *.
    intros or sigma H H0.
    unfold k_rules in H.
    decompose [ex and] H; clear H. 
    rename x into on, x0 into oa.
    set (cvars_tl := list_support kv_eq (prop_var_sequent
                         (subst_sequent sigma (k_conclusion_tail on)))).
    assert (H5 := subst_form_box_v _ 0 H0).
    destruct H5 as [v].
    destruct H.
    exists (k_rule (length cvars_tl)), 
           (rename_of_fun (k_rename_fun (v :: cvars_tl))).
    split.
      apply k_rules_rule.
    split.
      apply renaming_rename_of_fun.
    split.
      simpl conclusion.
      rewrite subst_k_rename_k_conclusion.
      apply multi_subset_right_sequent_support.
        apply NoDup_cons.
          clear. 
          intros H.
          rewrite in_map_iff in H.
          destruct H as [v'].
          destruct H.
          discriminate.
        apply NoDup_map_injective.
          apply injective_neg_box_v.
        apply list_support_correct_no_dup.
      intros f H5.
      eapply list_reorder_In.
        apply list_reorder_subst_sequent.
        apply list_reorder_symm.
        eexact H4.
      destruct H5.
        left.
        subst f.
        trivial.
      right.
      clear v H H3.
      apply in_map_iff in H5.
      destruct H5 as [v].
      destruct H.
      unfold cvars_tl in *.
      apply list_support_incl in H3.
      clear - H0 H H3.
      apply In_prop_var_sequent in H3.
      destruct H3 as [f'].
      destruct H1.
      assert (f = f').
        apply In_nth in H2.
        decompose [ex and or dep_and] H2; clear H2.
        rename x into i, a into i_less, b into H2.
        rewrite nth_subst_k_conclusion_tail in H2.
        subst f'.
        unfold box in *.
        repeat rewrite prop_var_formula_char in H1.
        unfold prop_var_modal_args in *.
        specialize (H0 (S i)).
        destruct (sigma (S i)); try contradiction.
        simpl in H1.
        destruct H1.
          subst k.
          subst f.
          trivial.
        contradiction.
      subst f'.
      trivial.
    rewrite H1; clear H1.
    simpl map.
    apply every_nth_cons.
      rewrite subst_k_rename_k_assumption.
      assert (lf_prop v :: map neg_v cvars_tl = 
                 sequent_support kop_eq kv_eq 
                                 (subst_sequent sigma (k_assumption on))).
        unfold cvars_tl in *.
        clear - H0 H. 
        simpl.
        rewrite subst_form_char.
        rewrite H; clear H.
        destruct (member (lambda_formula_eq kop_eq kv_eq) 
                    (lf_prop v)
                    (sequent_support kop_eq kv_eq 
                        (subst_sequent sigma (k_assumption_tail on)))) eqn:H.
          exfalso.
          apply member_In in H.
          apply sequent_support_incl in H.
          apply In_nth in H.
          decompose [ex and dep_and] H; clear H. 
          rename x into i, a into i_less, b into H.
          rewrite nth_subst_k_assumption_tail in H.
          discriminate.
        clear H.
        f_equal.
        rewrite prop_var_sequent_subst_k_conclusion_tail; trivial.
        assert (H := prop_sequent_subst_k_assumption_tail _ on H0).
        assert (H1 := neg_sequent_subst_k_assumption_tail sigma on).
        rewrite prop_var_sequent_support; trivial.
        rewrite <- destruct_neg_sequent.
            trivial.
          apply every_nth_sequent_support.
          trivial.
        apply every_nth_sequent_support.
        trivial.
      rewrite H1; clear H1.
      eapply propositional_cut_contraction_weakening.
                apply sequent_multiset_reordered_sequent_list_set.
              apply rank_sequent_set_sequent_list_set.
              apply every_nth_cons.
                eapply rank_sequent_list_reorder.
                  apply list_reorder_subst_sequent.
                  eexact H2.
                apply propositional_renaming; trivial.
                apply propositional_sequent_k_assumption.
              apply every_nth_empty.
            apply sequent_support_correct_content.
          discriminate.
        apply rank_sequent_sequent_support.
        apply propositional_renaming; trivial.
        apply propositional_sequent_k_assumption.
      apply provable_with_assumption.
      eexists.
      split.
        apply list_reorder_subst_sequent.
        apply list_reorder_symm.
        eexact H2.
      left.
      trivial.
    apply every_nth_empty.
  Qed.


  (***************************************************************************)
  (** *** Absorbtion of cut *)
  (***************************************************************************)

  Lemma k_absorbs_cut : absorbs_cut kop_eq kv_eq k_rules.
  Proof.
    unfold absorbs_cut in *.
    intros rl rr sl sr il ir il_less ir_less H H0 H1 H2 H3.
    unfold k_rules in H, H0.
    decompose [ex and or dep_and] H; clear H.
    rename x into nl, x0 into la.
    decompose [ex and or dep_and] H0; clear H0.
    rename x into nr, x0 into ra.
    lapply (list_reorder_occurence_full _ 
                 (subst_sequent sl (k_conclusion nl)) _ il_less).
      intros H0.
      decompose [ex and or dep_and] H0; clear H0.
      rename x into il', a into il_less'.
      rewrite H8 in *.
      lapply (list_reorder_occurence_full _ 
                 (subst_sequent sr (k_conclusion nr)) _ ir_less).
        intros H0.
        decompose [ex and or dep_and] H0; clear H0.
        rename x into ir', a into ir_less'.
        rewrite H11 in *.
        destruct il'.
          destruct ir'.
            discriminate.
          simpl in H3, H8, H10.
          clear il_less'.
          assert (H13 := subst_form_box_v _ 0 H2).
          destruct H13 as [rv].
          destruct H0.
          set (cvars_tl := prop_var_sequent ((cutout_nth 
                      (subst_sequent sr (k_conclusion_tail nr)) ir')
                      ++ subst_sequent sl (k_conclusion_tail nl))).
          exists (k_rule (length cvars_tl)), 
                 (rename_of_fun (k_rename_fun (rv :: cvars_tl))).
          split.
            apply k_rules_rule.
          split.
            apply renaming_rename_of_fun.
          split.
            simpl conclusion.
            eapply multi_subset_trans.
              apply sequent_support_correct_subset.
            exists [].
            rewrite subst_k_rename_k_conclusion.
            rewrite app_nil_r.
            eapply list_reorder_trans_rev.
              apply list_reorder_append_both.
                apply list_reorder_symm.
                eexact H10.
              apply list_reorder_symm.
              eexact H12.
            clear - H1 H2 H13.
            rewrite cutout_nth_cons_0.
            eapply list_reorder_trans_rev.
              apply list_reorder_append_swap.
            simpl subst_sequent.
            rewrite cutout_nth_cons_succ.
            simpl.
            rewrite H13.
            apply list_reorder_cons_head.
            unfold cvars_tl in *; clear cvars_tl.
            rewrite <- destruct_neg_mod_sequent.
                apply list_reorder_refl.
              apply simple_modal_sequent_append.
                apply simple_modal_sequent_cutout_nth.
                apply simple_modal_sequent_subst_k_conclusion_tail; trivial.
              apply simple_modal_sequent_subst_k_conclusion_tail; trivial.
            apply every_nth_append.
              apply every_nth_cutout_nth.
              apply neg_sequent_subst_k_conclusion_tail.
            apply neg_sequent_subst_k_conclusion_tail.
          apply every_nth_cons.
            clear - H1 H2 H3 H4 H5 H H6 H0.
            rewrite H4; clear H4.
            rewrite H; clear H.
            simpl map.
            rewrite subst_k_rename_k_assumption.
            apply provable_with_rule 
                  with (assum := [subst_sequent sl (k_assumption nl);
                                  subst_sequent sr (k_assumption nr)]).
              split.
                right.
                exists [], (subst_sequent sl (k_assumption_tail nl)), 
                       (firstn (S ir') (subst_sequent sr (k_assumption nr))),
                       (skipn (2 + ir') (subst_sequent sr (k_assumption nr))).
                eexists.
                simpl assumptions.
                simpl conclusion.
                split.
                  f_equal.
                    reflexivity.
                  assert (S ir' < length (subst_sequent sr (k_assumption nr))).
                    clear - ir_less'.
                    rewrite length_subst_sequent.
                    rewrite length_k_assumption.
                    rewrite length_subst_sequent in ir_less'.
                    rewrite length_k_conclusion in ir_less'.
                    trivial.
                  rewrite list_split_n_equal with (n_less := H).
                    trivial.
                  clear - H3.
                  simpl.
                  rewrite nth_subst_k_conclusion_tail in H3.
                  unfold box_v, box in *.
                  rewrite subst_form_char in *.
                  simpl in H3.
                  rewrite subst_form_char in *.
                  inversion H3; clear H3.
                  rewrite nth_subst_k_assumption_tail.
                  rewrite H1.
                  trivial.
                clear - H1 H2 H0. 
                eapply list_reorder_trans.
                  apply list_reorder_cons_head.
                  apply list_reorder_map.
                  apply prop_var_sequent_list_reorder.
                  apply list_reorder_append_swap.
                clear cvars_tl.
                rewrite app_nil_l.
                unfold k_assumption at 2.
                simpl subst_sequent at 4.
                simpl firstn.
                rewrite subst_form_char.
                rewrite H0.
                apply (list_reorder_cons_parts _ _ (subst_sequent sl _) 
                                   (firstn ir' _ ++ skipn (2 + ir') _)).
                rewrite prop_var_sequent_append.
                rewrite map_app.
                apply list_reorder_append_both.
                  rewrite prop_var_sequent_subst_k_conclusion_tail; trivial.
                  rewrite <- destruct_neg_sequent.
                      apply list_reorder_refl.
                    apply prop_sequent_subst_k_assumption_tail; trivial.
                  apply neg_sequent_subst_k_assumption_tail.
                rewrite prop_var_sequent_cutout_nth.
                  rewrite map_cutout_nth.
                  apply list_reorder_append_both.
                    rewrite prop_var_sequent_subst_k_conclusion_tail; trivial.
                    rewrite <- destruct_neg_sequent.
                        apply list_reorder_refl.
                      apply prop_sequent_subst_k_assumption_tail; trivial.
                    apply neg_sequent_subst_k_assumption_tail.
                  rewrite prop_var_sequent_subst_k_conclusion_tail; trivial.
                  rewrite <- destruct_neg_sequent.
                      apply list_reorder_refl.
                    apply prop_sequent_subst_k_assumption_tail; trivial.
                  apply neg_sequent_subst_k_assumption_tail.
                intros i i_less.
                rewrite nth_subst_k_conclusion_tail.
                unfold box in *.
                repeat rewrite prop_var_formula_char.
                unfold prop_var_modal_args in *.
                simpl.
                specialize (H2 (S i)).
                destruct (sr (S i)); try contradiction.
                trivial.
              clear - H1 H2.
              split.
                apply every_nth_cons.
                  apply prop_sequent_is_propositional.
                  apply prop_sequent_subst_k_assumption; trivial.
                apply every_nth_cons.
                  apply prop_sequent_is_propositional.
                  apply prop_sequent_subst_k_assumption; trivial.
                apply every_nth_empty.
              simpl.
              intros i i_less.
              destruct i.
                simpl.
                apply propositional_lf_prop.
              simpl.
              rewrite nth_map.
              apply propositional_neg_inv.
              apply propositional_lf_prop.
            apply every_nth_cons.
              apply provable_with_assumption.
              eexists.
              split.
                apply list_reorder_subst_sequent.
                apply list_reorder_symm.
                eexact H5.
              left.
              trivial.
            apply every_nth_cons.
              apply provable_with_assumption.
              eexists.
              split.
                apply list_reorder_subst_sequent.
                apply list_reorder_symm.
                eexact H6.
              right.
              left.
              trivial.
            apply every_nth_empty.
          apply every_nth_empty.
        destruct ir'.
          discriminate.
        exfalso.
        clear - H3.
        simpl in *.
        rewrite nth_subst_k_conclusion_tail in *.
        rewrite nth_subst_k_conclusion_tail in *.
        discriminate.
      apply list_reorder_subst_sequent.
      trivial.
    apply list_reorder_subst_sequent.
    trivial.
  Qed.


  (***************************************************************************)
  (** *** Syntactic cut elimination for K *)
  (***************************************************************************)

  Theorem k_syntactic_cut :
    admissible_rule_set (GR_set k_rules) (empty_sequent_set KV KL) is_cut_rule.
  Proof.
    eapply syntactic_admissible_cut.
            exists kv_enum.
            trivial.
          apply one_step_rule_set_k_rules.
        apply k_absorbs_congruence.
      apply k_absorbs_contraction.
    apply k_absorbs_cut.
  Qed.

  Theorem k_syntactic_contraction :
    admissible_rule_set (GR_set k_rules) (empty_sequent_set KV KL)
                        is_contraction_rule.
  Proof.
    eapply syntactic_admissible_contraction.
            exists kv_enum.
            trivial.
          apply one_step_rule_set_k_rules.
        apply k_absorbs_congruence.
      apply k_absorbs_contraction.
    apply k_absorbs_cut.
  Qed.

End K_absorb.
