(* 
 * Formalized Cut Elimination in Coalgebraic Logics
 * 
 * Copyright (C) 2013 - 2013 Hendrik Tews
 * 
 * This file is part of my formalization of "Cut Elimination in 
 * Coalgebraic Logics" by Dirk Pattinson and Lutz Schroeder.
 * 
 * The formalization is free software: you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * The formalization is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the parent
 * directories for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with the formalization in the file COPYING. 
 * If not, see <http://www.gnu.org/licenses/>.
 * 
 * $Id: k_nd.v,v 1.4.2.1 2013/04/10 12:11:56 tews Exp $
 *)


(** ** K example, equivalence with the (N), (D) rule set 

      This is work in progress to prove the equivalence of the K-rule
      set with the rules (N) and (D).
*)

Require Export k_syntax.

Section K_nd.

  (***************************************************************************)
  (** *** (N), (D) rule set *)
  (***************************************************************************)

  Definition k_n_rule(r : sequent_rule KV KL) : Prop :=
    assumptions r = [[lf_prop 0]] /\ conclusion r = [box_v 0].

  Definition k_d_rule(r : sequent_rule KV KL) : Prop :=
    exists(sa : sequent KV KL),
      assumptions r = [sa] /\ list_reorder sa (k_assumption 2) /\
      list_reorder (conclusion r) (k_conclusion 2).

  Definition k_nd_rules : set (sequent_rule KV KL) :=
    union k_n_rule k_d_rule.

  Lemma rule_multiset_k_nd : rule_multiset k_nd_rules.
  Proof.
    apply multiset_union.
      unfold rule_multiset, k_n_rule in *.
      intros or s H H0.
      destruct H.
      rewrite H1 in *.
      apply list_reorder_singleton in H0.
      subst s.
      exists or.
      repeat split; auto.
      rewrite H in *.
      intros n n_less_rs n_less_rr.
      erewrite nth_tcc_irr.
      apply list_reorder_refl.
    unfold rule_multiset, k_d_rule in *.
    intros or s H H0.
    decompose [ex and] H; clear H.
    rename x into sa.
    exists {| assumptions := [sa]; conclusion := s |}.
    repeat split; auto.
        rewrite H2.
        trivial.
      rewrite H2.
      simpl assumptions.
      intros n n_less_rs n_less_rr.
      erewrite nth_tcc_irr.
      apply list_reorder_refl.
    exists sa.
    repeat split; auto.
    simpl.
    eapply list_reorder_trans.
      apply list_reorder_symm.
      eexact H0.
    trivial.
  Qed.

  Lemma provable_k_nd_hyp_list_reorder : 
    forall(hyp : set (sequent KV KL))(s1 s2 : sequent KV KL),
      sequent_multiset hyp ->
      list_reorder s1 s2 ->
      provable k_nd_rules hyp s1 ->
        provable k_nd_rules hyp s2.
  Proof.
    intros hyp s1 s2 H H0 H1.
    eapply multiset_provability.
          apply rule_multiset_k_nd.
        trivial.
      eexact H0.
    trivial.
  Qed.


  (***************************************************************************)
  (** *** Towards the equivalence of the rule sets *)
  (***************************************************************************)

  Lemma k_nd_subset : subset k_nd_rules k_rules.
  Proof.
    intros r H.
    unfold k_nd_rules, k_rules in *.
    destruct H.
      destruct H.
      exists 0, (k_assumption 0).
      rewrite H.
      rewrite H0.
      repeat split.
        apply list_reorder_refl.
      apply list_reorder_refl.
    unfold k_d_rule in *.
    decompose [ex and or dep_and] H; clear H.
    rename x into sa.
    eexists.
    eexists.
    eauto.
  Qed.

  Lemma k_n_rule_eq_1 : forall(r : sequent_rule KV KL),
    k_n_rule r ->
      r = k_rule 0.
  Proof.
    intros r H.
    unfold k_n_rule, k_rule in *.
    destruct H.
    destruct r.
    simpl in *.
    rewrite H.
    rewrite H0.
    trivial.
  Qed.

End K_nd.
