
open Memcheck

let flags = [Channel stdout; Verbose_statistics; 
	     Start_indent 2]
(* 
 * let flags = [Channel stdout; Verbose_blocks; Verbose_types; Verbose_statistics;
 * 	     Verbose_spinner; Verbose_type_ids; Verbose_trace;
 * 	     Start_indent 2]
 *)
;;

Printf.eprintf "check 0 int ... \n%!";
assert(check flags 0 int_type_descr);
Printf.eprintf "... survived !\n%!";

Printf.eprintf "check 5 int ... \n%!";
assert(check flags 5 int_type_descr);
Printf.eprintf "... survived !\n%!";

(* the following test fails if the side effects done inside int_type_descr
 * are carried into this check
 *)
let l = [1;2;3] in
let cdr = Obj.field (Obj.repr l) 1 
in
  Obj.set_field cdr 0 (Obj.repr l); (* currupted now *)
  Printf.eprintf "check currupted int list ... \n%!";
  assert(check (Verbose_trace::flags) l 
	   (list_type_descr int_type_descr) = false);
  Printf.eprintf "... survived !\n%!"
;;

Printf.eprintf "check int list ... \n%!";
assert(check flags [4;5;6] (list_type_descr int_type_descr));
Printf.eprintf "... survived !\n%!"

;;

(* design a test that breaks if the internal hash tables use real
 * equality instead of pointer equality
 *)

let a = [| 0; 0 |] in
let b = (0, 0) in
let type_expr = tuple_type_descr [array_type_descr int_type_descr;
				  tuple_type_descr [int_type_descr; 
						    int_type_descr]]
in
  Printf.eprintf "check int array int tuple ... \n%!";
  assert(check flags (a,b) type_expr);
  Printf.eprintf "... survived !\n%!"

;;
  
let x = [| |] in
let type_expr = array_type_descr int_type_descr
in
  Printf.eprintf "check empty int array ... \n%!";
  assert(check flags x type_expr);
  Printf.eprintf "... survived !\n%!"

;;


let j = [0] in
let k : int option list = Obj.magic j in
let l : (int list * int option list) = (j, k) in
let type_expr_ok =
  tuple_type_descr
    [list_type_descr int_type_descr; list_type_descr int_type_descr]
in
let type_expr_fail =
  tuple_type_descr
    [list_type_descr int_type_descr;
     list_type_descr (option_type_descr int_type_descr)]
in
  Printf.eprintf "check tuple with shared block with valid type ... \n%!";
  assert(check flags l type_expr_ok);
  Printf.eprintf "... survived !\n%!";
  Printf.eprintf "check tuple with shared block of invalid different types ... \n%!";
  assert(check (Verbose_trace::flags) l type_expr_fail = false);
  Printf.eprintf "... survived !\n%!"
;;

