//  Copyright 2006-2007, Hendrik Tews, All rights reserved.            *
//  See file license.txt for terms of use                              *
//**********************************************************************

// ocaml reflection functions for enums and flag sets
// hopefully soon generated by astgen

#ifndef ELSA_FLAG_TYPES
#define ELSA_FLAG_TYPES


#include "ocaml_reflection_base.h"
#include "cc_flags.h"
#include "cc_type.h"       // FunctonType
#include "template.h"
#include "implconv.h"



//********************** value reflection ************************************
// for flag sets

value ocaml_reflect_DeclFlags(DeclFlags const *);
value ocaml_reflect_CVFlags(CVFlags *);
value ocaml_reflect_FunctionFlags(const FunctionFlags *);
value ocaml_reflect_StandardConversion(const StandardConversion *);


// for real enums
// !!! All these functions follow the general scheme and take the
// !!! flags to convert as a pointer. There is however one exception:
// !!! ocaml_reflect_TemplateThingKind takes the flags as value because
// !!! they can only be accessed via TemplateInfo::getKind(), which obviously 
// !!! returns only a value.
value ocaml_reflect_SimpleTypeId(const SimpleTypeId *);
value ocaml_reflect_TypeIntr(const TypeIntr *);
value ocaml_reflect_AccessKeyword(const AccessKeyword *);
value ocaml_reflect_OverloadableOp(const OverloadableOp *);
value ocaml_reflect_UnaryOp(const UnaryOp *);
value ocaml_reflect_EffectOp(const EffectOp *);
value ocaml_reflect_BinaryOp(const BinaryOp *);
value ocaml_reflect_CastKeyword(const CastKeyword *);
value ocaml_reflect_CompoundKeyword(const CompoundType::Keyword *);
value ocaml_reflect_DeclaratorContext(const DeclaratorContext *);
value ocaml_reflect_ScopeKind(const ScopeKind *);
value ocaml_reflect_TemplateThingKind(const TemplateThingKind);
value ocaml_reflect_ImplicitConversion_Kind(const ImplicitConversion_Kind *);


#endif // ELSA_FLAG_TYPES
