(* Otags reloaded
 * 
 * Hendrik Tews Copyright (C) 2010
 * 
 * This file is part of "Otags reloaded".
 * 
 * "Otags reloaded" is free software: you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * "Otags reloaded" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the parent
 * directories for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with "Otags reloaded". If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * $Id: global.mli,v 1.7 2010-08-24 11:21:31 tews Exp $
 * 
 * global variables
 * 
 *)


val verbose : bool ref

val silent : bool ref

  (* whether to recursively search subdirectories *)
val recurse_subdirectories : bool ref

  (* whether to use internal or external mode *)
val use_internal_parsers : bool ref

  (* if true generate an emacs tags file, if false generate a vi one *)
val emacs_mode : bool ref

  (* name of the output file *)
val tags_file_name : string option ref

  (* whether to append to the tags file *)
val append_to_tags_file : bool ref

  (* Whether some "-external" occured. Then "-pr" and "-pc" do not 
   * switch back to internal mode
   *)
val switched_to_external_by_hand : bool ref

val default_parser_list : string list

val parser_list : string list ref

val camlp4_search_path : string list ref

