(* This test program demonstrates that Camlp4QuotationCommon.Make installs 
 * quotations per side-effect in the Quotation submodule of its Syntax 
 * argument. For creating a new syntax one therefore has to use fresh
 * Quotation submodules.
*)

module PC = Camlp4.PreCast

module type Camlp4Syntax = Camlp4.Sig.Camlp4Syntax 
  with module Loc = PC.Loc
  and module Ast = PC.Ast


module FreshGrammar(Unit : sig end) 
  : Camlp4Syntax with module Token = PC.Gram.Token
                 and module Gram = PC.Gram
= Camlp4.OCamlInitSyntax.Make(PC.Ast)(PC.Gram)
		       (* variant that uses a fresh quotation submodule *)
		       (Camlp4.Struct.Quotation.Make(PC.Ast))

		       (* variant that reuses PreCast.Quotation *)
		       (* (PC.Quotation) *)


module Make
  (HostSyntax : Camlp4Syntax)
  (MakeQuotationSyntax : functor(EmptySyntax : Camlp4Syntax) -> Camlp4Syntax) 
  : Camlp4Syntax
  =
struct
  module New_gram = PC.MakeGram(PC.Lexer)
  module EmptySyntax = 
    Camlp4.OCamlInitSyntax.Make(PC.Ast)(New_gram)(HostSyntax.Quotation)
  module QuotationSyntax = MakeQuotationSyntax(EmptySyntax)
  module X = 
    Camlp4QuotationCommon.Make(QuotationSyntax)(HostSyntax.AntiquotSyntax)
  include X
end

module type Pos = sig
    val pos : string
end

module Check_quot(P : Pos)(S : Camlp4Syntax) = struct
  let _ = 
    try
      S.Quotation.find "str_item" S.Quotation.DynAst.str_item_tag;
      Printf.printf "%s: quotation found\n%!" P.pos
    with
      | Not_found ->
	Printf.printf "%s: NO QUOTATION\n%!" P.pos
end



module A = FreshGrammar(struct end)

module B = Camlp4OCamlRevisedParser.Make(A)


module X_A_1 = Check_quot(struct let pos = "A1" end)(A)
module X_B_1 = Check_quot(struct let pos = "B1" end)(B)


module C = Make(B)(Camlp4OCamlRevisedParser.Make)

module X_A_2 = Check_quot(struct let pos = "A2" end)(A)
module X_B_2 = Check_quot(struct let pos = "B2" end)(B)
module X_C_2 = Check_quot(struct let pos = "C2" end)(C)


module D = Camlp4.OCamlInitSyntax.Make(PC.Ast)(PC.Gram)(PC.Quotation)

module X_A_3 = Check_quot(struct let pos = "A3" end)(A)
module X_B_3 = Check_quot(struct let pos = "B3" end)(B)
module X_C_3 = Check_quot(struct let pos = "C3" end)(C)
module X_D_3 = Check_quot(struct let pos = "D3" end)(D)


module E = Camlp4OCamlRevisedParser.Make(D)

module X_A_4 = Check_quot(struct let pos = "A4" end)(A)
module X_B_4 = Check_quot(struct let pos = "B4" end)(B)
module X_C_4 = Check_quot(struct let pos = "C4" end)(C)
module X_D_4 = Check_quot(struct let pos = "D4" end)(D)
module X_E_4 = Check_quot(struct let pos = "E4" end)(E)

